/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.resourcechickens;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_156;
import net.minecraft.class_1676;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_2965;
import net.minecraft.class_3962;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import wallywhip.resourcechickens.compat.modmenu.ModMenuManager;
import wallywhip.resourcechickens.entity.AngryChickenEntity;
import wallywhip.resourcechickens.entity.DuckEggProjectileEntity;
import wallywhip.resourcechickens.entity.ResourceChickenEntity;
import wallywhip.resourcechickens.entity.XpEggProjectileEntity;
import wallywhip.resourcechickens.init.initBlocks;
import wallywhip.resourcechickens.init.initChickenConfigs;
import wallywhip.resourcechickens.init.initChickenRegistry;
import wallywhip.resourcechickens.init.initItems;
import wallywhip.resourcechickens.init.initSounds;
import wallywhip.resourcechickens.init.initTiles;
import wallywhip.resourcechickens.items.ChickenCatcherItemDispenser;
import wallywhip.resourcechickens.items.LiquidEggDispenser;
import wallywhip.resourcechickens.items.ManureItemDispenser;
import wallywhip.resourcechickens.json.ChickenData;

public class ResourceChickens
implements ModInitializer {
    public static final String MOD_ID = "resourcechickens";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final class_2960 FOOLISH_LOC = new class_2960("resourcechickens", "textures/entity/vanilla/chicken_fool.png");
    public static final class_2960[] FESTIVE_LOC = new class_2960[]{new class_2960("resourcechickens", "textures/entity/vanilla/chicken_fest1.png"), new class_2960("resourcechickens", "textures/entity/vanilla/chicken_fest2.png")};
    public static boolean isFestive = false;
    public static boolean isFoolish = false;
    public static final class_5321<class_1761> ITEM_GROUP = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)new class_2960("resourcechickens", "tab"));

    public void onInitialize() {
        initItems.register();
        initBlocks.register();
        initTiles.register();
        initSounds.register();
        initChickenRegistry.register();
        initChickenConfigs.loadConfigs();
        class_2378.method_39197((class_2378)class_7923.field_44687, ITEM_GROUP, (Object)FabricItemGroup.builder().method_47321((class_2561)class_2561.method_43471((String)"itemGroup.resourcechickens.tab")).method_47320(() -> new class_1799((class_1935)initItems.EGG_DUCK)).method_47317((context, entry) -> {
            entry.method_45421((class_1935)initItems.ANIMAL_NET);
            entry.method_45421((class_1935)initItems.CATCHER);
            entry.method_45421((class_1935)initItems.CATCHER_CREATIVE);
            entry.method_45421((class_1935)initItems.FEATHER_DUCK);
            entry.method_45421((class_1935)initItems.EGG_DUCK);
            entry.method_45421((class_1935)initItems.DUCK);
            entry.method_45421((class_1935)initItems.DUCK_COOKED);
            entry.method_45421((class_1935)initItems.XP_ITEM);
            entry.method_45421((class_1935)initItems.EGG_XP);
            entry.method_45421((class_1935)initItems.MANURE_ITEM);
            entry.method_45421((class_1935)initItems.NEST_BLOCK_ITEM);
            entry.method_45421((class_1935)initItems.EGG_WATER);
            entry.method_45421((class_1935)initItems.EGG_LAVA);
            entry.method_45421((class_1935)initBlocks.DUCK_EGG_BLOCK);
            entry.method_45421((class_1935)initBlocks.EGG_BLOCK);
            entry.method_45421((class_1935)initBlocks.MANURE_BLOCK);
            entry.method_45421((class_1935)initBlocks.MANURE_FARMLAND_BLOCK);
        }).method_47324());
        ModMenuManager.getConfig().setAllowFestiveTextures(ModMenuManager.getConfig().isAllowFestiveTextures());
        initChickenRegistry.DATA.forEach((id, chickenData) -> {
            if (id.equals("angry")) {
                FabricDefaultAttributeRegistry.register(chickenData.entityType, (class_5132.class_5133)AngryChickenEntity.createChickenAttributes());
            } else {
                FabricDefaultAttributeRegistry.register(chickenData.entityType, (class_5132.class_5133)ResourceChickenEntity.createChickenAttributes(id));
            }
        });
        initChickenRegistry.DATA.forEach((id, chickenData) -> {
            if (chickenData.spawnNaturally) {
                if (chickenData.biomesWhitelist != null && !chickenData.biomesWhitelist.isEmpty()) {
                    for (JsonElement w : chickenData.biomesWhitelist) {
                        BiomeModifications.addSpawn(biomeSelectionContext -> biomeSelectionContext.getBiomeKey().method_29177().equals((Object)new class_2960(w.getAsString())), (class_1311)chickenData.spawnType, chickenData.entityType, (int)chickenData.spawnWeight, (int)1, (int)2);
                    }
                } else {
                    BiomeModifications.addSpawn((Predicate)BiomeSelectors.spawnsOneOf((class_1299[])new class_1299[]{class_1299.field_6132}), (class_1311)chickenData.spawnType, chickenData.entityType, (int)chickenData.spawnWeight, (int)1, (int)2);
                }
            }
        });
        class_2960 idChicken = class_7923.field_41177.method_10221((Object)class_1299.field_6132);
        BiomeModifications.create((class_2960)idChicken).add(ModificationPhase.REMOVALS, BiomeSelectors.spawnsOneOf((class_1299[])new class_1299[]{class_1299.field_6132}), context -> context.getSpawnSettings().removeSpawnsOfEntityType(class_1299.field_6132));
        ServerEntityEvents.ENTITY_LOAD.register((entity, serverWorld) -> {
            ChickenData chickenData;
            if (entity.method_5864() == class_1299.field_6132 && ModMenuManager.getConfig().isOverrideVanillaChickens().booleanValue() && (chickenData = initChickenRegistry.DATA.get("chicken")) != null) {
                class_2487 compound = entity.method_5647(new class_2487());
                compound.method_10582("id", "resourcechickens:chicken");
                class_1297 bird = class_1299.method_17842((class_2487)compound, (class_1937)serverWorld, e -> {
                    e.method_5808(entity.method_23317(), entity.method_23318(), entity.method_23321(), e.method_36454(), e.method_36455());
                    return e;
                });
                entity.method_5650(class_1297.class_5529.field_26999);
                if (bird != null) {
                    serverWorld.method_30736(bird);
                }
            }
        });
        class_2315.method_10009((class_1935)initItems.EGG_DUCK, (class_2357)new class_2965(){

            protected class_1676 method_12844(class_1937 level, class_2374 position, class_1799 itemStack) {
                return (class_1676)class_156.method_654((Object)((Object)new DuckEggProjectileEntity(level, position.method_10216(), position.method_10214(), position.method_10215())), projectile -> projectile.method_16940(itemStack));
            }
        });
        class_2315.method_10009((class_1935)initItems.EGG_XP, (class_2357)new class_2965(){

            protected class_1676 method_12844(class_1937 level, class_2374 position, class_1799 itemStack) {
                return (class_1676)class_156.method_654((Object)((Object)new XpEggProjectileEntity(level, position.method_10216(), position.method_10214(), position.method_10215())), projectile -> projectile.method_16940(itemStack));
            }
        });
        class_2315.method_10009((class_1935)initItems.EGG_WATER, (class_2357)new LiquidEggDispenser());
        class_2315.method_10009((class_1935)initItems.EGG_LAVA, (class_2357)new LiquidEggDispenser());
        class_2315.method_10009((class_1935)initItems.CATCHER_ITEM, (class_2357)new ChickenCatcherItemDispenser());
        class_2315.method_10009((class_1935)initItems.CATCHER_ITEM_DUCK, (class_2357)new ChickenCatcherItemDispenser());
        class_2315.method_10009((class_1935)initItems.MANURE_ITEM, (class_2357)new ManureItemDispenser());
        class_3962.field_17566.put((Object)initItems.MANURE_ITEM.method_8389(), 0.65f);
    }

    public static int calcNewEggLayTime(class_5819 r, ChickenData chickenData, int growth) {
        if (chickenData.eggLayTime == 0) {
            return 0;
        }
        int egg = r.method_43048(chickenData.eggLayTime) + chickenData.eggLayTime;
        return (int)Math.max(1.0f, (float)egg * (10.0f - (float)growth + 1.0f) / 10.0f);
    }

    public static int calcDropQuantity(int gain) {
        if (gain < 5) {
            return 1;
        }
        if (gain < 10) {
            return 2;
        }
        return 3;
    }

    public static List<class_1799> calcDrops(int gain, ChickenData chickenData, int fortune) {
        class_5819 r;
        class_1799 itemStack;
        ArrayList<class_1799> lst = new ArrayList<class_1799>();
        if (!chickenData.dropItem.isEmpty() && !(itemStack = ResourceChickens.getDropItem(chickenData.dropItem)).method_7960()) {
            if (chickenData.dropItemNBT != null) {
                itemStack.method_7980(chickenData.dropItemNBT.method_10553());
            }
            int dropQuantity = ResourceChickens.calcDropQuantity(gain) + fortune;
            if (itemStack.method_7946()) {
                itemStack.method_7939(dropQuantity);
                lst.add(itemStack);
            } else {
                for (int a = 0; a < dropQuantity; ++a) {
                    class_1799 itm = itemStack.method_7972();
                    lst.add(itm);
                }
            }
        }
        if ((r = class_5819.method_43047()).method_43048(100) + 1 <= ModMenuManager.getConfig().chanceDropFeathers()) {
            lst.add(new class_1799((class_1935)(chickenData.hasTrait == 1 ? initItems.FEATHER_DUCK : class_1802.field_8153)));
        }
        if (r.method_43048(100) + 1 <= ModMenuManager.getConfig().chanceDropPoop()) {
            lst.add(new class_1799((class_1935)initItems.MANURE_ITEM));
        }
        return lst;
    }

    public static String formatTime(int milli) {
        int secs = milli / 20;
        int mins = secs / 60;
        int hours = mins / 60;
        if (hours == 0) {
            return String.format("%02d:%02d", mins, secs % 60);
        }
        return String.format("%02d:%02d:%02d", hours, mins, secs % 60);
    }

    public static class_1799 getDropItem(String dropItem) {
        if (dropItem.startsWith("tag:")) {
            class_2960 ID = new class_2960(dropItem.substring(4));
            class_6862 itemTagKey = class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)ID);
            if (itemTagKey != null) {
                Optional bb;
                Optional aa = class_7923.field_41178.method_40266(itemTagKey);
                if (aa.isPresent() && (bb = ((class_6885.class_6888)aa.get()).method_40243(class_5819.method_43047())).isPresent()) {
                    return new class_1799((class_6880)bb.get());
                }
            } else {
                Optional bb;
                Optional aa;
                class_6862 blockTagKey = class_6862.method_40092((class_5321)class_7923.field_41175.method_30517(), (class_2960)ID);
                if (blockTagKey != null && (aa = class_7923.field_41175.method_40266(blockTagKey)).isPresent() && (bb = ((class_6885.class_6888)aa.get()).method_40243(class_5819.method_43047())).isPresent()) {
                    return new class_1799((class_1935)((class_6880)bb.get()).comp_349());
                }
            }
        } else {
            return new class_1799((class_1935)class_7923.field_41178.method_10223(new class_2960(dropItem)));
        }
        return class_1799.field_8037;
    }

    public static class_2960 getTexture(ResourceChickenEntity entityIn) {
        if (isFestive && entityIn.chickenData.ID.equals("chicken")) {
            long l = entityIn.method_5667().getMostSignificantBits();
            int i = Math.abs((int)(l % 2L));
            return FESTIVE_LOC[i];
        }
        if (isFoolish && entityIn.chickenData.ID.equals("chicken")) {
            return FOOLISH_LOC;
        }
        return entityIn.chickenData.chickenTexture;
    }

    public static class_2960 getTexture(ChickenData chickenData, UUID uuid) {
        if (isFestive && chickenData.ID.equals("chicken")) {
            long l = uuid.getMostSignificantBits();
            int i = Math.abs((int)(l % 2L));
            return FESTIVE_LOC[i];
        }
        if (isFoolish && chickenData.ID.equals("chicken")) {
            return FOOLISH_LOC;
        }
        return chickenData.chickenTexture;
    }
}

